;								EJEMPLO 24
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR1 en el modo contador de eventos externos. Divisin de frecuencias.
;
;Mediante el generador de onda cuadrada del laboratorio se aplican pulsos por la 
;lnea RC0/T1CKI. El contador cuenta N eventos procedentes del generador y a una frecuencia
;conocida (Fg). Al llegar a 0, la lnea de salida RB0 cambia de estado. La frecuencia de salida
;en esta lnea ser: Fg/2*N
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Valor_N		equ	.10		;Valor por el que se divide la frecuencia

		
			org	0x00				;Vector de RESET	
			goto	Inicio
			org	0x04				;Vector de interrupcin
			goto	Inter
			org	0x05
		
Inter		movlw	low ~Valor_N
			movwf	TMR1L
			movlw	high ~Valor_N
			movwf	TMR1H			;Restaura el TMR1 con el valor a dividir
			bcf		PIR1,TMR1IF		;Repone el flag del TMR1
			movlw	b'00000001'
			xorwf	PORTB,F			;RB0 cambia de estado
			retfie		
		
;Programa principal

Inicio	    clrf 	PORTB			;Borra los latch de salida
			bsf		STATUS,RP0		;Selecciona banco 1
			clrf	TRISB			;Puerta B se configura como salida
			movlw	b'11111111'		
			movwf	TRISC			;Puerta C como entrada
			bsf		PIE1,TMR1IE		;Habilita interrupcin del TMR1
			bcf		STATUS,RP0		;Selecciona banco 0

;El TMR1 acta como contador externo asncrono y con un preescaler de 1:1

			movlw	b'00000111'
			movwf	T1CON
			movlw	low ~Valor_N
			movwf	TMR1L
			movlw	high ~Valor_N
			movwf	TMR1H			;Carga el TMR1 con el valor a dividir		
			movlw	b'11000000'
			movwf	INTCON			;Habilita interrupciones

Loop		sleep					;Modo de bajo consumo
			nop
			goto	Loop			;Bucle infinito		

			end						;Fin del programa fuente
